--	Block.lua - Simple block class demonstrating how luabind classes work.
--  ----------------------------------------------------------------------------
--	This file is part of 'EXCOSC Base' a simple OSC-aware game skeleton.
--	Copyright (C) 2013  Niall Moody
--	
--	This program is free software: you can redistribute it and/or modify
--	it under the terms of the GNU General Public License as published by
--	the Free Software Foundation, either version 3 of the License, or
--	(at your option) any later version.
--
--	This program is distributed in the hope that it will be useful,
--	but WITHOUT ANY WARRANTY; without even the implied warranty of
--	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--	GNU General Public License for more details.
--
--	You should have received a copy of the GNU General Public License
--	along with this program.  If not, see <http://www.gnu.org/licenses/>.
--	----------------------------------------------------------------------------

--------------------------------------------------------------------------------
--	The basic class declaration.
class 'Block'

--------------------------------------------------------------------------------
--	The class constructor.
function Block:__init(pos, col)
	--The block's position.
	self.position = TwoFloats(pos)
	--The block's colour (HSL).
	self.colour = ThreeFloats(col)
end

--------------------------------------------------------------------------------
--	Draws the block.
function Block:draw(d)
	d:drawImage("Block",
				self.position-64.0,
				TwoFloats(1.0),
				hslToRgb(self.colour),
				1.0)
end
