//	SoundFileLoader.cpp - Base class for sound file loaders.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "SoundFileLoader.h"

using std::wstring;
using std::map;

//------------------------------------------------------------------------------
SoundFileFactory::SoundFileFactory()
{

}

//------------------------------------------------------------------------------
SoundFileFactory::~SoundFileFactory()
{

}

//------------------------------------------------------------------------------
SoundFileLoaderPtr SoundFileFactory::getLoader(const FilePath& soundFile) const
{
	SoundFileLoaderPtr retval;
	map<wstring, SoundFileLoader::Creator *>::const_iterator it;

	it = creators.find(soundFile.getExtension());
	if(it != creators.end())
		retval = it->second->createLoader(soundFile);

	return retval;
}

//------------------------------------------------------------------------------
void SoundFileFactory::registerCreator(const wstring& extension,
									   SoundFileLoader::Creator *creator)
{
	creators.insert(make_pair(extension, creator));
}
