//	NullSounder.h - A Sounder that does nothing.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef NULLSOUNDER_H_
#define NULLSOUNDER_H_

#include "sound/Sounder.h"

///	A Sounder that does nothing.
class NullSounder : public Sounder
{
  public:
	///	Constructor.
	NullSounder():
	Sounder()
	{

	};
	///	Destructor.
	~NullSounder() {};

	///	Called for every audio block.
	/*!
		This is where you do any audio generation/playback/calculations.
	 */
	void getAudio(float *input, float *output, int numSamples)
	{
		for(int i=0;i<(numSamples*2);++i)
			output[i] = 0.0f;
	};

	///	Called for each sound file resource by LoadingScreen.
	void loadSoundFileResource(SoundFileLoaderPtr soundFileLoader) {};
};

#endif
