//	Delay.h - Simple (stereo) audio delay class.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef DELAY_H_
#define DELAY_H_

///	Simple (stereo) audio delay class.
class Delay
{
  public:
	///	Constructor.
	Delay();
	///	Destructor.
	~Delay();

	///	Generates the audio for the delay, rewrites it to it's buffer input.
	void getAudio(float *buffer, int numSamples);

	///	Sets the delay time (in seconds).
	void setDelay(float val);
	///	Sets the amount of feedback (0->1).
	void setFeedback(float val);
	///	Sets the mix value (0->1: no delay, full input -> full delay, no input).
	void setMix(float val);

	///	Sets the samplerate.
	void setSamplerate(float val);
  private:
	///	The maximum delay size.
	enum
	{
		BufferSize = 88200
	};

	///	The two delay buffers.
	float delayLine[2][BufferSize];

	///	The read pointer.
	float readIndex;
	///	The write pointer.
	float writeIndex;

	///	The delay time (in seconds).
	float delay;
	///	The amount of feedback to apply.
	float feedback;
	///	The amount the delay signal is mixed with the input signal.
	float mix;

	///	The samplerate we're using.
	float samplerate;
};

#endif
