//	LuaClasses.h - Used to register our various helper structs/classes.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2013  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef LUACLASSES_H_
#define LUACLASSES_H_

#include <string>

struct lua_State;

namespace LuaClasses
{

///	Used to register our various helper structs/classes.
void registerLuaClasses(lua_State *luaState);

///	Returns the debug output string.
std::string& getDebugOutput();
///	Sets the debug output string's text.
void writeDebugOutput(const std::string& text);

};

#endif
