//	TwoFloats.cpp - Simple struct containing three floats.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	----------------------------------------------------------------------------

#include "TwoFloats.h"

//------------------------------------------------------------------------------
TwoFloats operator+(float op1, const TwoFloats& op2)
{
	TwoFloats retval;

	retval.x = op1 + op2.x;
	retval.y = op1 + op2.y;

	return retval;
}

//------------------------------------------------------------------------------
TwoFloats operator-(float op1, const TwoFloats& op2)
{
	TwoFloats retval;

	retval.x = op1 - op2.x;
	retval.y = op1 - op2.y;

	return retval;
}

//------------------------------------------------------------------------------
TwoFloats operator*(float op1, const TwoFloats& op2)
{
	TwoFloats retval;

	retval.x = op1 * op2.x;
	retval.y = op1 * op2.y;

	return retval;
}

//------------------------------------------------------------------------------
TwoFloats operator/(float op1, const TwoFloats& op2)
{
	TwoFloats retval;

	retval.x = op1 / op2.x;
	retval.y = op1 / op2.y;

	return retval;
}
