//	Thread.cpp - Simple thread base class.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "Thread.h"
#include "DebugHeaders.h"

using std::string;

//------------------------------------------------------------------------------
BackendThread::Creator *Thread::backendThreadCreator = 0;

//------------------------------------------------------------------------------
Thread::Thread(const string& threadName):
name(threadName)
{
	if(backendThreadCreator)
		thread = backendThreadCreator->createBackendThread();
}

//------------------------------------------------------------------------------
Thread::~Thread()
{
	if(thread)
		thread->waitToFinish();
}

//------------------------------------------------------------------------------
void Thread::startThread(Thread *threadPointer)
{
	if(thread)
	{
		thread->createThread(threadMethod,
							 name,
							 static_cast<void *>(threadPointer));
	}
	else
		DebugStatement(L"Thread: No backend thread implementation exists!");
}

//------------------------------------------------------------------------------
int Thread::threadMethod(void *data)
{
	Thread *thread = static_cast<Thread *>(data);

	if(thread->run())
		return 1;
	else
		return 0;
}

//------------------------------------------------------------------------------
void Thread::wait(int milliseconds)
{
	if(backendThreadCreator)
		backendThreadCreator->wait(milliseconds);
}

//------------------------------------------------------------------------------
void Thread::setBackendThreadCreator(BackendThread::Creator *creator)
{
	if(!backendThreadCreator)
		backendThreadCreator = creator;
	else
		DebugStatement(L"Thread: Trying to add multiple BackendThread::Creators!");
}
