//	Random.h - Stupidly basic random number generator that's hopefully better
//			   than rand().
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef RANDOM_H_
#define RANDOM_H_

#include <ctime>

///	Stupidly basic random number generator that's hopefully better than rand().
class Random
{
  public:
	///	Constructor.
	Random()
	{
		seed = (int)time(0);
	};
	///	Destructor.
	~Random() {};

	///	A global random number generator.
	static Random& getGlobal();

	///	Returns a random int (0->(max-1)).
	inline int getRandomInt(int max)
	{
		return (int)(getRandomFloat() * ((float)max-0.0001f));
	};
	///	Returns a random float (0->1).
	inline float getRandomFloat()
	{
		++seed;
		return (getRand(seed)+1.0f)*0.5f;
	};
  private:
	///	Helper method.
	inline float getRand(int val)
	{
		val = (val<<13) ^ val;
		return (float)( 1.0 - ( (val * (val * val * 15731 + 789221) + 1376312589) & 0x7fffffff) / 1073741824.0);
	};

	///	Seed for the generator.
	int seed;
};

#endif
