//	LogFile.h - Simple log file class.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef LOGFILE_H_
#define LOGFILE_H_

#include "UTF8File.h"

///	Simple log file class.
/*!
	Log files will be saved to <home dir>/<name>-<time>.txt
 */
class LogFile
{
  public:
	///	Constructor.
	LogFile(const std::wstring& name);
	///	Destructor.
	~LogFile();

	///	Writes the passed-in string to the log file.
	void write(const std::wstring& text);
	///	Writes the passed-in string to the log file.
	void write(const std::string& text);
  private:
	///	The file we're writing to.
	UTF8File logFile;
};

#endif
