//	DebugHeaders.h - Bits and pieces that are very useful for debugging.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef DEBUGHEADERS_H_
#define DEBUGHEADERS_H_

#include "UTF8File.h"

#include <sstream>

#if defined(WIN32) && defined(DEBUG)
#define NiallNew new (_NORMAL_BLOCK, __FILE__, __LINE__)
#else
#define NiallNew new
#endif

///	Singleton used to write DebugStatements to a log file.
class DebugLogFile
{
  public:
	///	Returns the sole instance of the class (not thread-safe, btw).
	static DebugLogFile& getInstance();

	///	Returns the temporary string buffer.
	std::wstringstream& getBuffer() {return tempBuffer;};
	///	Writes the temporary stringbuffer to the log file.
	void writeBuffer();

	///	Turns debug logging on or off.
	void setLogging(bool val);
	///	Returns whether or not we're currently logging debug messages.
	bool getLogging() const {return logging;};
  private:
	///	Constructor.
	DebugLogFile();
	///	Destructor.
	~DebugLogFile();

	///	The log file stream.
	UTF8File logFile;
	///	Temp string buffer.
	std::wstringstream tempBuffer;

	///	True if we're currently logging debug messages.
	bool logging;
};

#define DebugStatement(val) {DebugLogFile::getInstance().getBuffer() << val << std::endl << L"\t\t\t\t\t\t\t\t\t\t(" << __FILE__ << L"  line:" << __LINE__ << L")" << std::endl << std::endl; DebugLogFile::getInstance().writeBuffer();};

#endif
