//	DebugHeaders.cpp - Bits and pieces that are very useful for debugging.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "DebugHeaders.h"

#include "FilePath.h"

#include <sstream>
#include <ctime>

using std::wstringstream;

//------------------------------------------------------------------------------
DebugLogFile& DebugLogFile::getInstance()
{
	static DebugLogFile retval;

	return retval;
}

//------------------------------------------------------------------------------
void DebugLogFile::writeBuffer()
{
	if(logging)
	{
		if(!logFile.getFail())
			logFile.writeText(tempBuffer.str().c_str(), true, true);
	}
	tempBuffer.str(L"");
}

//------------------------------------------------------------------------------
void DebugLogFile::setLogging(bool val)
{
	logging = val;
}

//------------------------------------------------------------------------------
DebugLogFile::DebugLogFile():
logging(false)
{
	wstringstream tempstr;

	tempstr << L"NiallDebugFile-" << time(NULL) << L".txt";
	FilePath path(FilePath::getHomeDir().getChild(tempstr.str()));

	logFile.setFilePath(path);
}

//------------------------------------------------------------------------------
DebugLogFile::~DebugLogFile()
{
	
}
