//	CriticalSection.cpp - Simple class representing a critical section.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "CriticalSection.h"

//------------------------------------------------------------------------------
BackendCritSec::Creator *CriticalSection::backendCritSecCreator = 0;

//------------------------------------------------------------------------------
CriticalSection::CriticalSection()
{
	if(backendCritSecCreator)
		backendCritSec = backendCritSecCreator->createBackendCritSec();
}

//------------------------------------------------------------------------------
CriticalSection::~CriticalSection()
{
	
}

//------------------------------------------------------------------------------
bool CriticalSection::lock()
{
	if(backendCritSec)
		return backendCritSec->lock();
	else
		return false;
}

//------------------------------------------------------------------------------
void CriticalSection::unlock()
{
	if(backendCritSec)
		backendCritSec->unlock();
}

//------------------------------------------------------------------------------
void CriticalSection::setBackendCritSecCreator(BackendCritSec::Creator *creator)
{
	backendCritSecCreator = creator;
}
