//	ColourHelpers.h - Some useful colour conversion functions.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef COLOURHELPERS_H_
#define COLOURHELPERS_H_

#include "ThreeFloats.h"

///	Some useful colour conversion functions.
namespace ColourHelpers
{

///	Converts an HSL colour to an RGB one.
ThreeFloats hslToRgb(const ThreeFloats& col);
///	Converts an RGB colour to an HSL one.
ThreeFloats rgbToHsl(const ThreeFloats& col);

///	Helper method used by hslToRgb().
float hueToRgb(float p, float q, float t);

};

#endif
