//	WidgetContainer.h - Base class for any containers of widgets.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef WIDGETCONTAINER_H_
#define WIDGETCONTAINER_H_

#include "c0xHeaders.h"
#include "Widget.h"

#include <vector>

///	Base class for any containers of widgets.
class WidgetContainer : public Widget
{
  public:
	///	Constructor.
	WidgetContainer();
	///	Destructor.
	~WidgetContainer();

	///	Draws the widget.
	void draw(DrawerPtr& d);

	///	Called when the mouse moves within this widget's bounds
	void mouseMove(const TwoFloats& pos);
	///	Called when a mouse button is clicked or released.
	void mouseButton(bool val, const TwoFloats& pos);
	///	Called when the mouse is outside the widget's bounds.
	void mouseLeave(const TwoFloats& pos);

	///	Adds a widget to this container.
	void addChild(shared_ptr<Widget> w);
	///	Returns the number of widgets within this container.
	int getNumChildren() const {return children.size();};
	///	Removes a child widget matching w.
	void removeChild(shared_ptr<Widget>& w);
	///	Removes the indexed child widget.
	void removeChild(int index);
	///	Removes all child widgets.
	void removeAllChildren();
  private:
	///	The child widgets.
	std::vector<shared_ptr<Widget> > children;
};

#endif
