//	WidgetContainer.cpp - Base class for any containers of widgets.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "WidgetContainer.h"

using namespace std;

//------------------------------------------------------------------------------
WidgetContainer::WidgetContainer():
Widget()
{
	
}

//------------------------------------------------------------------------------
WidgetContainer::~WidgetContainer()
{
	removeAllChildren();
}

//------------------------------------------------------------------------------
void WidgetContainer::draw(DrawerPtr& d)
{
	unsigned int i;

	for(i=0;i<children.size();++i)
		children[i]->draw(d);
}

//------------------------------------------------------------------------------
void WidgetContainer::mouseMove(const TwoFloats& pos)
{
	unsigned int i;

	for(i=0;i<children.size();++i)
		children[i]->mouseMoveTest(pos);
}

//------------------------------------------------------------------------------
void WidgetContainer::mouseButton(bool val, const TwoFloats& pos)
{
	unsigned int i;

	for(i=0;i<children.size();++i)
		children[i]->mouseButtonTest(val, pos);
}

//------------------------------------------------------------------------------
void WidgetContainer::mouseLeave(const TwoFloats& pos)
{
	unsigned int i;

	for(i=0;i<children.size();++i)
		children[i]->mouseMoveTest(pos);
}

//------------------------------------------------------------------------------
void WidgetContainer::addChild(shared_ptr<Widget> w)
{
	children.push_back(w);
}

//------------------------------------------------------------------------------
void WidgetContainer::removeChild(shared_ptr<Widget>& w)
{
	unsigned int i;

	for(i=0;i<children.size();++i)
	{
		if(children[i] == w)
		{
			children.erase(children.begin()+i);
			break;
		}
	}
}

//------------------------------------------------------------------------------
void WidgetContainer::removeChild(int index)
{
	unsigned int i;

	for(i=0;i<children.size();++i)
	{
		if(i == index)
		{
			children.erase(children.begin()+i);
			break;
		}
	}
}

//------------------------------------------------------------------------------
void WidgetContainer::removeAllChildren()
{
	children.clear();
}
