//	Widget.h - Base class for any widgets.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef WIDGET_H_
#define WIDGET_H_

#include "c0xHeaders.h"
#include "TwoFloats.h"

class Drawer;
typedef shared_ptr<Drawer> DrawerPtr;

///	Base class for any widgets.
class Widget
{
  public:
	///	Constructor.
	Widget();
	///	Destructor.
	virtual ~Widget();

	///	Draws the widget.
	virtual void draw(DrawerPtr& d) = 0;

	///	Called when the mouse moves within this widget's bounds.
	virtual void mouseMove(const TwoFloats& pos) = 0;
	///	Called when a mouse button is clicked or released.
	virtual void mouseButton(bool val, const TwoFloats& pos) = 0;
	///	Called when the mouse is outside the widget's bounds.
	virtual void mouseLeave(const TwoFloats& pos) {};

	///	Sets the position of the widget.
	void setPosition(const TwoFloats& pos);
	///	Returns the position of the widget.
	const TwoFloats& getPosition() const {return position;};

	///	Sets the size of the widget.
	void setSize(const TwoFloats& val);
	///	Returns the size of the widget.
	const TwoFloats& getSize() const {return size;};

	///	Called for mouse moves - does hit-testing and calls the relevant virtual method.
	void mouseMoveTest(const TwoFloats& pos);
	///	Called for mouse buttons - does hit-testing and calls the relevant virtual method.
	void mouseButtonTest(bool val, const TwoFloats& pos);
  private:
	///	The widget's position.
	TwoFloats position;
	///	The widget's size.
	TwoFloats size;

	///	If the previous mouse down occurred within this widget.
	bool lastMouseDown;
};

#endif
