//	Widget.cpp - Base class for any widgets.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "drawing/Drawer.h"
#include "Widget.h"

//------------------------------------------------------------------------------
Widget::Widget():
size(1.0f),
lastMouseDown(false)
{
	
}

//------------------------------------------------------------------------------
Widget::~Widget()
{
	
}

//------------------------------------------------------------------------------
void Widget::setPosition(const TwoFloats& pos)
{
	position = pos;
}

//------------------------------------------------------------------------------
void Widget::setSize(const TwoFloats& val)
{
	size = val;
}

//------------------------------------------------------------------------------
void Widget::mouseMoveTest(const TwoFloats& pos)
{
	if((pos >= position) && (pos < (position+size)))
		mouseMove(pos);
	else
		mouseLeave(pos);
}

//------------------------------------------------------------------------------
void Widget::mouseButtonTest(bool val, const TwoFloats& pos)
{
	if((pos >= position) && (pos < (position+size)))
	{
		if(val)
			lastMouseDown = true;
		mouseButton(val, pos);
	}
	else if(!val) //So clicking a button and releasing after the mouse has moved still works.
	{
		if(lastMouseDown)
		{
			lastMouseDown = false;
			mouseButton(val, pos);
		}
		else
			mouseLeave(pos); //away gets handled correctly.
	}
}
