//	StaticImage.h - A static image widget.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef STATICIMAGE_H_
#define STATICIMAGE_H_

#include "Widget.h"

///	A static image widget.
class StaticImage : public Widget
{
  public:
	///	Constructor.
	StaticImage(const std::wstring& im);
	///	Destructor.
	~StaticImage();

	///	Draws the image.
	void draw(DrawerPtr& d);

	///	Called when the mouse moves within this widget's bounds
	void mouseMove(const TwoFloats& pos) {};
	///	Called when a mouse button is clicked or released.
	void mouseButton(bool val, const TwoFloats& pos) {};
  private:
	///	The image's id.
	std::wstring image;

	///	True if the button's size has been set.
	bool sizeIsSet;
};

#endif
