//	StaticImage.cpp - A static image widget.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "drawing/Drawer.h"
#include "StaticImage.h"

//------------------------------------------------------------------------------
StaticImage::StaticImage(const std::wstring& im):
Widget(),
image(im),
sizeIsSet(false)
{
	
}

//------------------------------------------------------------------------------
StaticImage::~StaticImage()
{
	
}

//------------------------------------------------------------------------------
void StaticImage::draw(DrawerPtr& d)
{
	if(!sizeIsSet)
	{
		const Drawer::Image * const tempIm = d->getInternalImageData(image);
		if(tempIm)
		{
			setSize(tempIm->size);
			sizeIsSet = true;
		}
	}

	d->drawImage(image, getPosition());
}
