//	RadioButtons.h - Basic (vertical) radio buttons widget.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef RADIOBUTTONS_H_
#define RADIOBUTTONS_H_

#include "Callbacks.h"
#include "Widget.h"

///	Basic (vertical) radio buttons widget.
class RadioButtons : public Widget,
					 public ChangeBroadcaster
{
  public:
	///	Constructor.
	RadioButtons(const std::wstring& upImage,
				 const std::wstring& downImage,
				 int num);
	///	Destructor.
	~RadioButtons();

	///	Draws the button.
	void draw(DrawerPtr& d);

	///	Called when the mouse moves within this widget's bounds.
	void mouseMove(const TwoFloats& pos);
	///	Called when a mouse button is clicked or released.
	void mouseButton(bool val, const TwoFloats& pos);
	///	Called when the mouse is outside the widget's bounds.
	void mouseLeave(const TwoFloats& pos);

	///	Sets which button is currently selected.
	void setValue(int val);
	///	Returns which button is currently selected.
	int getValue() const {return value;};
  private:
	///	The button's up image.
	std::wstring up;
	///	The button's down image.
	std::wstring down;
	///	The height of a button.
	float buttonHeight;

	///	The number of buttons.
	int numButtons;
	///	The currently-selected button.
	int value;

	///	Whether the mouse button is currently down or not.
	bool mouseIsDown;
	///	If the mouse is over the button.
	bool mouseIsOver;

	///	True if the button's size has been set.
	bool sizeIsSet;
};

#endif
