//	RadioButtons.cpp - Basic (vertical) radio buttons widget.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "drawing/Drawer.h"
#include "RadioButtons.h"
#include "MouseCursor.h"

//------------------------------------------------------------------------------
RadioButtons::RadioButtons(const std::wstring& upImage,
						   const std::wstring& downImage,
						   int num):
Widget(),
ChangeBroadcaster(),
up(upImage),
down(downImage),
buttonHeight(1.0f),
numButtons(num),
value(0),
mouseIsDown(false),
mouseIsOver(false),
sizeIsSet(false)
{
	
}

//------------------------------------------------------------------------------
RadioButtons::~RadioButtons()
{
	
}

//------------------------------------------------------------------------------
void RadioButtons::draw(DrawerPtr& d)
{
	int i;
	TwoFloats tempPos(getPosition());

	if(!sizeIsSet)
	{
		const Drawer::Image * const tempIm = d->getInternalImageData(up);
		if(tempIm)
		{
			buttonHeight = tempIm->size.y;
			sizeIsSet = true;
		}
	}

	for(i=0;i<numButtons;++i)
	{
		if(i == value)
			d->drawImage(down, tempPos);
		else
			d->drawImage(up, tempPos);
		tempPos.y += buttonHeight;
	}
}

//------------------------------------------------------------------------------
void RadioButtons::mouseMove(const TwoFloats& pos)
{
	mouseIsOver = true;
	MouseCursor::getInstance().setImage(true);
}

//------------------------------------------------------------------------------
void RadioButtons::mouseButton(bool val, const TwoFloats& pos)
{
	if(val)
	{
		mouseIsDown = true;
		value = (int)((pos.y-getPosition().y)/buttonHeight);
		callChangeCallbacks(this, (float)value);
	}
	else
		mouseIsDown = false;
}

//------------------------------------------------------------------------------
void RadioButtons::mouseLeave(const TwoFloats& pos)
{
	if(mouseIsOver)
	{
		mouseIsOver = false;
		MouseCursor::getInstance().setImage(false);
	}
	mouseIsDown = false;
}

//------------------------------------------------------------------------------
void RadioButtons::setValue(int val)
{
	value = val;
}
