//	MouseCursor.h - Singleton class for drawing a mouse cursor.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef MOUSECURSOR_H_
#define MOUSECURSOR_H_

#include "Widget.h"

#include <string>

///	Singleton class for drawing a mouse cursor.
class MouseCursor : public Widget
{
  public:
	///	Returns the sole instance of the MouseCursor object.
	static MouseCursor& getInstance();

	///	Draws the cursor.
	void draw(DrawerPtr& d);

	///	Switches between the pointer (false) and hand (true) cursors.
	void setImage(bool val);
	///	Sets the images the pointer's drawn with.
	void setImages(const std::wstring& pointerImage,
				   const std::wstring& handImage,
				   const std::wstring& handClosedImage);

	///	So the object knows where the mouse currently is.
	void mouseMove(const TwoFloats& pos);
	///	Called when a mouse button is clicked or released.
	void mouseButton(bool val, const TwoFloats& pos);
  private:
	///	The constructor.
	MouseCursor();
	///	Destructor.
	~MouseCursor();

	///	The pointer image.
	std::wstring pointer;
	///	The hand image.
	std::wstring hand;
	///	The closed hand image.
	std::wstring handClosed;

	///	The cursor's current position.
	TwoFloats position;
	///	Whether the cursor's displaying the pointer or the hand.
	bool image;
	///	Whether the user is holding down the mouse button or not.
	bool mouseIsDown;

	///	Used to load the default cursor.
	bool defaultImageLoaded;
};

namespace MouseImages
{
    extern const char*  mousecursor_png;
    const int           mousecursor_pngSize = 2914;

    extern const char*  mousecursorhand_png;
    const int           mousecursorhand_pngSize = 2830;

    extern const char*  mousecursorhandclosed_png;
    const int           mousecursorhandclosed_pngSize = 2700;

};

#endif
