//	HorizontalSlider.h - A horizontal slider widget.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef HORIZONTALSLIDER_H_
#define HORIZONTALSLIDER_H_

#include "Widget.h"
#include "Callbacks.h"

///	A horizontal slider widget.
class HorizontalSlider : public Widget,
						 public ChangeBroadcaster
{
  public:
	///	Constructor.
	HorizontalSlider(const std::wstring& sliderImage);
	///	Destructor.
	~HorizontalSlider();

	///	Draws the widget.
	void draw(DrawerPtr& d);

	///	Called when the mouse moves within this widget's bounds.
	void mouseMove(const TwoFloats& pos);
	///	Called when a mouse button is clicked or released.
	void mouseButton(bool val, const TwoFloats& pos);
	///	Called when the mouse is outside the widget's bounds.
	void mouseLeave(const TwoFloats& pos);

	///	Sets the slider's value.
	void setValue(float val);
  private:
	///	The image of the slider's handle.
	std::wstring image;

	///	The slider's value (0->1).
	float value;
	///	The size of the handle.
	float handleSize;
	///	Whether the handle is currently being dragged or not.
	bool dragging;

	///	If the mouse is over the slider handle.
	bool mouseIsOver;

	///	True if the slider's size has been set.
	bool sizeIsSet;
};

#endif
