//	GradientBackground.h - Simple gradient background widget container.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef GRADIENTBACKGROUND_H_
#define GRADIENTBACKGROUND_H_

#include "ThreeFloats.h"
#include "Widget.h"

///	Simple gradient background widget container.
class GradientBackground : public Widget
{
  public:
	///	Constructor.
	GradientBackground(const ThreeFloats& colTop,
					   float alphaTop,
					   const ThreeFloats& colBottom,
					   float alphaBottom);
	///	Destructor.
	~GradientBackground();

	///	Draws the gradient.
	void draw(DrawerPtr& d);

	///	Called when the mouse moves within this widget's bounds
	void mouseMove(const TwoFloats& pos) {};
	///	Called when a mouse button is clicked or released.
	void mouseButton(bool val, const TwoFloats& pos) {};
  private:
	///	The gradient top colour.
	ThreeFloats colour1;
	///	The gradient top alpha.
	float alpha1;
	///	The gradient bottom colour.
	ThreeFloats colour2;
	///	The gradient bottom alpha.
	float alpha2;
};

#endif
