//	GradientBackground.cpp - Simple gradient background widget container.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "GradientBackground.h"
#include "drawing/Drawer.h"

//------------------------------------------------------------------------------
GradientBackground::GradientBackground(const ThreeFloats& colTop,
									   float alphaTop,
									   const ThreeFloats& colBottom,
									   float alphaBottom):
Widget(),
colour1(colTop),
alpha1(alphaTop),
colour2(colBottom),
alpha2(alphaBottom)
{
	
}

//------------------------------------------------------------------------------
GradientBackground::~GradientBackground()
{
	
}

//------------------------------------------------------------------------------
void GradientBackground::draw(DrawerPtr& d)
{
	d->fillGradient(getPosition(),
					getSize(),
					colour1,
					colour2,
					alpha1,
					alpha2);
}
