//	Callbacks.cpp - Base classes for various widget callbacks.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "Callbacks.h"

using std::wstring;

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
TriggerBroadcaster::TriggerBroadcaster()
{
	
}

//------------------------------------------------------------------------------
TriggerBroadcaster::~TriggerBroadcaster()
{
	
}

//------------------------------------------------------------------------------
void TriggerBroadcaster::callTriggerCallbacks(Widget *w,
											  bool val,
											  const wstring& id)
{
	unsigned int i;

	for(i=0;i<callbacks.size();++i)
		callbacks[i]->triggered(w, val, id);
}

//------------------------------------------------------------------------------
void TriggerBroadcaster::addTriggerCallback(TriggerCallback *c)
{
	callbacks.push_back(c);
}

//------------------------------------------------------------------------------
void TriggerBroadcaster::removeTriggerCallback(TriggerCallback *c)
{
	unsigned int i;

	for(i=0;i<callbacks.size();++i)
	{
		if(callbacks[i] == c)
		{
			callbacks.erase(callbacks.begin()+i);
			break;
		}
	}
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
ChangeBroadcaster::ChangeBroadcaster()
{
	
}

//------------------------------------------------------------------------------
ChangeBroadcaster::~ChangeBroadcaster()
{
	
}

//------------------------------------------------------------------------------
void ChangeBroadcaster::callChangeCallbacks(Widget *w,
											float val,
											const wstring& id)
{
	unsigned int i;

	for(i=0;i<callbacks.size();++i)
		callbacks[i]->valueChanged(w, val, id);
}

//------------------------------------------------------------------------------
void ChangeBroadcaster::callFinishedChanging(Widget *w)
{
	unsigned int i;

	for(i=0;i<callbacks.size();++i)
		callbacks[i]->finishedChanging(w);
}

//------------------------------------------------------------------------------
void ChangeBroadcaster::addChangeCallback(ChangeCallback *c)
{
	callbacks.push_back(c);
}

//------------------------------------------------------------------------------
void ChangeBroadcaster::removeChangeCallback(ChangeCallback *c)
{
	unsigned int i;

	for(i=0;i<callbacks.size();++i)
	{
		if(callbacks[i] == c)
		{
			callbacks.erase(callbacks.begin()+i);
			break;
		}
	}
}
