//	Button.h - A simple (trigger-style) button.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef BUTTON_H_
#define BUTTON_H_

#include "Callbacks.h"
#include "Widget.h"

///	A simple (trigger-style) button.
class Button : public Widget,
			   public TriggerBroadcaster
{
  public:
	///	Constructor.
	/*!
		\param up The button's up image.
		\param down The button's down image.
	 */
	Button(const std::wstring& up, const std::wstring& down);
	///	Destructor.
	~Button();

	///	Draws the button.
	void draw(DrawerPtr& d);

	///	Called when the mouse moves within this widget's bounds.
	void mouseMove(const TwoFloats& pos);
	///	Called when a mouse button is clicked or released.
	void mouseButton(bool val, const TwoFloats& pos);
	///	Called when the mouse is outside the widget's bounds.
	void mouseLeave(const TwoFloats& pos);
  private:
	///	The button's up image.
	std::wstring upImage;
	///	The button's down image.
	std::wstring downImage;

	///	Whether the mouse button is currently down or not.
	bool mouseIsDown;
	///	If the mouse is over the button.
	bool mouseIsOver;

	///	True if the button's size has been set.
	bool sizeIsSet;
};

#endif
