//	Button.cpp - A simple (trigger-style) button.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "drawing/Drawer.h"
#include "MouseCursor.h"
#include "Button.h"

//------------------------------------------------------------------------------
Button::Button(const std::wstring& up, const std::wstring& down):
Widget(),
TriggerBroadcaster(),
upImage(up),
downImage(down),
mouseIsDown(false),
mouseIsOver(false),
sizeIsSet(false)
{
	
}

//------------------------------------------------------------------------------
Button::~Button()
{
	
}

//------------------------------------------------------------------------------
void Button::draw(DrawerPtr& d)
{
	if(!sizeIsSet)
	{
		const Drawer::Image * const tempIm = d->getInternalImageData(upImage);
		if(tempIm)
		{
			setSize(tempIm->size);
			sizeIsSet = true;
		}
	}

	if(mouseIsDown)
		d->drawImage(downImage, getPosition());
	else
		d->drawImage(upImage, getPosition());
}

//------------------------------------------------------------------------------
void Button::mouseMove(const TwoFloats& pos)
{
	mouseIsOver = true;
	MouseCursor::getInstance().setImage(true);
}

//------------------------------------------------------------------------------
void Button::mouseButton(bool val, const TwoFloats& pos)
{
	if(val)
	{
		mouseIsDown = true;
		callTriggerCallbacks(this, true);
	}
	else
		mouseIsDown = false;
}

//------------------------------------------------------------------------------
void Button::mouseLeave(const TwoFloats& pos)
{
	if(mouseIsOver)
	{
		mouseIsOver = false;
		MouseCursor::getInstance().setImage(false);
	}
	mouseIsDown = false;
}
