//	ScreenRes.cpp - Simple helper functions to return the user's resolution.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "ScreenRes.h"

#ifdef WIN32
#include "Windows.h"
#elif defined(LINUX)
#include <X11/Xlib.h>
#endif

namespace ScreenResolution
{

//------------------------------------------------------------------------------
int getScreenWidth()
{
#ifdef WIN32
	return GetSystemMetrics(SM_CXSCREEN);
#elif defined(LINUX)
	int retval = 1024;
	Display *d = XOpenDisplay(NULL);

	retval = XDisplayWidth(d, XDefaultScreen(d));
	XCloseDisplay(d);

	return retval;
#endif
}

//------------------------------------------------------------------------------
int getScreenHeight()
{
#ifdef WIN32
	return GetSystemMetrics(SM_CYSCREEN);
#elif defined(LINUX)
	int retval = 768;
	Display *d = XOpenDisplay(NULL);

	retval = XDisplayHeight(d, XDefaultScreen(d));
	XCloseDisplay(d);

	return retval;
#endif
}

}
