//	ImageLoader.h - Class used to load images from different file formats.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef IMAGELOADER_H_
#define IMAGELOADER_H_

#include "FilePath.h"

#include <stdint.h>

//------------------------------------------------------------------------------
///	Simple struct representing some image data.
struct ImageData
{
	///	The actual data (in 32-bit RGBA format).
	uint8_t *data;
	///	The width (in pixels) of the image.
	uint32_t width;
	///	The height (in pixels) of the image.
	uint32_t height;
};

//------------------------------------------------------------------------------
///	Class used to load images from different file formats.
/*!
	This just loads images from .png, .jpg etc. files, and gives you the raw
	image data to with as you wish.

	The actual implementation of this class will be backend-specific, so make
	sure you include the correct implementation with your project.
 */
class ImageLoader
{
  public:
	///	Constructor.
	ImageLoader();
	///	Destructor.
	~ImageLoader();

	///	Loads an image from memory.
	/*!
		The caller is responsible for deleting the ImageData::data pointer.
	 */
	ImageData loadImage(const char *data, uint32_t size);
	///	Loads an image from a file.
	/*!
		The caller is responsible for deleting the ImageData::data pointer.
	 */
	ImageData loadImage(const FilePath& path);
};

#endif
