//	GLHeaders.h - File including the relevant OpenGL headers for different
//				  platforms.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef GLHEADERS_H_
#define GLHEADERS_H_

#ifndef OSX
#include "GL/glew.h"

//glClearDepthf seems to be missing from the version of GLEW I have on linux.
#ifndef glClearDepthf
#define glClearDepthf(val) glClearDepth(val)
#endif

#else
#include "OpenGL/gl.h"
#include "OpenGL/glext.h"
#include "OpenGL/glu.h"

///	The version of XCode I'm using doesn't have all the functions we need, so we just map them from the relevant extensions.
#ifdef GL_APPLE_vertex_array_object

#pragma message "Mapping GL_APPLE_vertex_array_object to GL_ARB_vertex_array_object"

#define GL_ARB_vertex_array_object GL_APPLE_vertex_array_object

#define glGenVertexArrays glGenVertexArraysAPPLE
#define glBindVertexArray glBindVertexArrayAPPLE
#define glDeleteVertexArrays glDeleteVertexArraysAPPLE

#endif

#ifndef GL_VERSION_3_0

#pragma message "Mapping GL_EXT_framebuffer_object to standard frame buffer methods"

#define glGenFramebuffers glGenFramebuffersEXT
#define glBindFramebuffer glBindFramebufferEXT
#define glGenRenderbuffers glGenRenderbuffersEXT
#define glBindRenderbuffer glBindRenderbufferEXT
#define glRenderbufferStorage glRenderbufferStorageEXT
#define glFramebufferRenderbuffer glFramebufferRenderbufferEXT
#define glFramebufferTexture2D glFramebufferTexture2DEXT
#define glCheckFramebufferStatus glCheckFramebufferStatusEXT
#define GL_FRAMEBUFFER GL_FRAMEBUFFER_EXT
#define GL_RENDERBUFFER GL_RENDERBUFFER_EXT
#define GL_DEPTH_ATTACHMENT GL_DEPTH_ATTACHMENT_EXT
#define GL_COLOR_ATTACHMENT0 GL_COLOR_ATTACHMENT0_EXT
#define GL_FRAMEBUFFER_COMPLETE GL_FRAMEBUFFER_COMPLETE_EXT

#pragma message "Mapping glClearDepthf to glClearDepth"

#define glClearDepthf glClearDepth

#endif

#endif

#ifndef GLAPIENTRY
#  if defined(__MINGW32__)
#    define GLAPIENTRY __stdcall
#  elif (_MSC_VER >= 800) || defined(_STDCALL_SUPPORTED) || defined(__BORLANDC__)
#    define GLAPIENTRY __stdcall
#  else
#    define GLAPIENTRY
#  endif
#endif

#endif
