//	FontMetrics.h - Map which keeps track of all the glyph positions etc. in
//					a font.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef FONTMETRICS_H_
#define FONTMETRICS_H_

#include <string>
#include <map>

//------------------------------------------------------------------------------
///	Struct which represents all the important information about a glyph in a font.
struct GlyphMetrics
{
	///The glyph's image id.
	/*!
		This is essentially the same kind of id as that passed to
		Drawer::drawImage() etc.
	 */
	std::wstring image;
	///	The glyph's width.
	float width;
	///	The starting offset of the glyph.
	float xOffset;
	///	The advance value of the glyph.
	float advance;
	///	The distance between the baseline and the top of the glyph.
	float yBearing;
	///	The amount to skip when moving to the next line.
	/*!
		This value will be identical for all glyphs of a particular font.
	 */
	float lineSkip;
};

//------------------------------------------------------------------------------
///	Map which keeps track of all the glyph positions etc. in a font.
typedef std::map<wchar_t, GlyphMetrics> FontMetrics;

#endif
