//	FontAtlas.cpp - Base class for the different font renderers.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "FontAtlas.h"

using std::wstring;
using std::vector;

//	----------------------------------------------------------------------------
FontAtlas::FontAtlas():
TextureAtlas(0, 0, 0, 0)
{

}

//	----------------------------------------------------------------------------
FontAtlas::~FontAtlas()
{

}

//	----------------------------------------------------------------------------
FilePath FontAtlas::findFontFile(const wstring& name)
{
	unsigned int i;
	FilePath retval;
	vector<FilePath> systemDirs;

	wstring nameExt = name;

	nameExt.append(L".ttf");

	//First check system font dirs.
	systemDirs = FilePath::getFontsDirs();
	for(i=0;i<systemDirs.size();++i)
	{
		if(systemDirs[i].getChild(nameExt).exists())
		{
			retval = systemDirs[i].getChild(nameExt);
			break;
		}
	}

	//Next check DataFilesDir/fonts.
	if(retval.getPath() == L"")
	{
		FilePath tempPath = FilePath::getDataFilesDir().getChild(L"fonts").getChild(nameExt);

		if(tempPath.exists())
			retval = tempPath;
	}

	if(retval.getPath() == L"")
	{
		nameExt = name;

		nameExt.append(L".otf");

		//First check system font dirs.
		systemDirs = FilePath::getFontsDirs();
		for(i=0;i<systemDirs.size();++i)
		{
			if(systemDirs[i].getChild(nameExt).exists())
			{
				retval = systemDirs[i].getChild(nameExt);
				break;
			}
		}

		//Next check DataFilesDir/fonts.
		if(retval.getPath() == L"")
		{
			FilePath tempPath = FilePath::getDataFilesDir().getChild(L"fonts").getChild(nameExt);

			if(tempPath.exists())
				retval = tempPath;
		}
	}

	return retval;
}
