//	SingleImage.h - Class representing a single image, stored as static data.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef SINGLEIMAGE_H_
#define SINGLEIMAGE_H_

#include <string>

///	Class representing a single image, stored as static data.
/*!
	This is the base class for any images too big to be put in a TextureAtlas.
	Subclasses simply store their image data as static const variables, and pass
	those variables to the SingleImage constructor.
 */
class SingleImage
{
  public:
	///	Constructor.
	SingleImage(const char *data, const int dataSize):
	imageData(data),
	imageDataSize(dataSize)
	{

	};
	///	Destructor.
	virtual ~SingleImage() {};

	///	Returns this image's name.
	virtual const std::wstring getName() const = 0;

	///	Returns the image data for this atlas.
	const char *getImageData() const {return imageData;};
	///	Returns the size of the image data for this atlas.
	const int getImageDataSize() const {return imageDataSize;};
  private:
	///	The image data for this atlas.
	const char *imageData;
	///	The size of the image data for this atlas.
	const int imageDataSize;
};

#endif
