//	Shader.h - Class representing the text of a shader.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef SHADER_H_
#define SHADER_H_

#include "FilePath.h"

#include <string>

///	Class representing the text of a shader.
/*!
	Base class for any shaders. Subclasses will be generated by
	AVLibResourceGenerator, which will fill out the shader texts and its name.
 */
class Shader
{
  public:
	///	Constructor.
	Shader(const std::wstring& vertex,
		   const std::wstring& fragment,
		   const std::wstring& name);
	///	Constructor.
	Shader(const std::wstring& name);
	///	Destructor.
	virtual ~Shader();

	///	Returns the name of the shader.
	const std::wstring& getName() const {return shaderName;};
	///	Returns the vertex shader text.
	const std::wstring& getVertexShader() const {return vertexShader;};
	///	Returns the fragment shader text.
	const std::wstring& getFragmentShader() const {return fragmentShader;};

	///	Helper method. Loads the contents of a shader file into a wstring.
	static void loadShaderFile(const FilePath& file, std::wstring& text);
  protected:
	///	Sets the vertex shader text.
	void setVertexShader(const std::wstring& text);
	///	Sets the fragment shader text.
	void setFragmentShader(const std::wstring& text);
  private:
	///	The shader's name.
	std::wstring shaderName;
	///	The text of the vertex shader.
	std::wstring vertexShader;
	///	The text of the fragment shader.
	std::wstring fragmentShader;
};

#endif
