//	Shader.cpp - Class representing the text of a shader.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "Shader.h"
#include "UTF8File.h"

using std::wstring;

//------------------------------------------------------------------------------
Shader::Shader(const wstring& vertex,
			   const wstring& fragment,
			   const wstring& name):
shaderName(name),
vertexShader(vertex),
fragmentShader(fragment)
{

}

//------------------------------------------------------------------------------
Shader::Shader(const wstring& name):
shaderName(name)
{

}

//------------------------------------------------------------------------------
Shader::~Shader()
{

}

//------------------------------------------------------------------------------
void Shader::setVertexShader(const std::wstring& text)
{
	vertexShader = text;
}

//------------------------------------------------------------------------------
void Shader::setFragmentShader(const std::wstring& text)
{
	fragmentShader = text;
}

//------------------------------------------------------------------------------
void Shader::loadShaderFile(const FilePath& file, wstring& text)
{
	UTF8File shaderFile(file);

	shaderFile.readFile(text);
}
