//	SDL2.0Thread.h - A Thread implementation based on SDL 2.0.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef SDL2_0THREAD_H_
#define SDL2_0THREAD_H_

#include "Thread.h"

struct SDL_Thread;

///	A Thread implementation based on SDL 2.0.
class SDL2_0Thread : public BackendThread
{
  public:
	///	Constructor.
	SDL2_0Thread();
	///	Destructor.
	~SDL2_0Thread();

	///	Creates and starts a thread.
	bool createThread(ThreadMethod threadMethod,
					  const std::string& name,
					  void *data);
	///	Waits for the thread to finish.
	void waitToFinish();

	///	Simple class used to construct an instance of a BackendThread subclass.
	class SDL2_0Creator : public BackendThread::Creator
	{
	  public:
		///	Constructor.
		SDL2_0Creator() {};
		///	Destructor.
		~SDL2_0Creator() {};

		///	Returns a new instance of a BackendThread subclass.
		BackendThreadPtr createBackendThread() const
		{
			return BackendThreadPtr(new SDL2_0Thread());
		};

		///	Tells the current thread to wait the passed-in number of milliseconds.
		void wait(int milliseconds) const;
	};

	///	Our instance of SDL2_0Creator.
	static SDL2_0Creator creator;
  private:
	///	The SDL thread struct.
	SDL_Thread *thread;
};

#endif
