//	SDL2.0CriticalSection.h - A CriticalSection implementation based on SDL2.0.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef SDL2_0CriticalSection_H_
#define SDL2_0CriticalSection_H_

#include "CriticalSection.h"

typedef struct SDL_semaphore SDL_sem;

///	A CriticalSection implementation based on SDL2.0.
class SDL2_0CriticalSection : public BackendCritSec
{
  public:
	///	Constructor.
	SDL2_0CriticalSection();
	///	Destructor.
	~SDL2_0CriticalSection();

	///	(Waits until the critical section is free and) Locks the Critical Section.
	/*!
		\return True if it was successfully locked, false otherwise.
	 */
	bool lock();
	///	Unlocks the critical section.
	void unlock();

	///	Simple class used to construct an instance of a BackendCritSec subclass.
	class SDL2_0Creator : public BackendCritSec::Creator
	{
	  public:
		///	Constructor.
		SDL2_0Creator() {};
		///	Destructor.
		~SDL2_0Creator() {};

		///	Returns a new instance of a BackendCritSec subclass.
		BackendCritSecPtr createBackendCritSec() const
		{
			return BackendCritSecPtr(new SDL2_0CriticalSection());
		};
	};

	///	Our instance of SDL2_0Creator.
	static SDL2_0Creator creator;
  private:
	///	The SDL semaphore this critical section is based on.
	SDL_sem *semaphore;
};

#endif
