//	SDL1.2Thread.h - A Thread implementation based on SDL 1.2.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "SDL1.2Thread.h"
#include "DebugHeaders.h"

#include "SDL_thread.h"
#include "SDL_timer.h"

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
SDL1_2Thread::SDL1_2Creator SDL1_2Thread::creator;

//------------------------------------------------------------------------------
SDL1_2Thread::SDL1_2Thread():
thread(0)
{

}

//------------------------------------------------------------------------------
SDL1_2Thread::~SDL1_2Thread()
{
	//Just in case.
	if(thread)
		waitToFinish();
}

//------------------------------------------------------------------------------
bool SDL1_2Thread::createThread(ThreadMethod threadMethod,
							    const std::string& name,
							    void *data)
{
	if(!thread)
	{
		thread = SDL_CreateThread(threadMethod,
								  static_cast<void *>(data));
		if(!thread)
			DebugStatement(L"SDL1.2Thread: Could not create thread.");
	}

	return (thread != 0);
}

//------------------------------------------------------------------------------
void SDL1_2Thread::waitToFinish()
{
	if(thread)
	{
		SDL_WaitThread(thread, NULL);
		thread = 0;
	}
	else
		DebugStatement(L"SDL1.2Thread: Calling waitToFinish() on a non-existent thread.");
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
void SDL1_2Thread::SDL1_2Creator::wait(int milliseconds) const
{
	SDL_Delay(milliseconds);
}
