//	sdl1.2Main.cpp - Basic main for the SDL1.2 backend.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2011  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#if defined(WIN32) && defined(DEBUG)
#pragma warning(disable : 4786) //Stupid MS headers...

#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>
#endif

#include "SDL1.2CriticalSection.h"
#include "SDL1.2Application.h"
#include "SDL1.2Thread.h"

#include "DebugHeaders.h"
#include "UTF8File.h"

#include <iostream>

using std::wstring;
using std::string;
using std::vector;

//------------------------------------------------------------------------------
int main(int argc, char* argv[])
{
	Thread::setBackendThreadCreator(&SDL1_2Thread::creator);
	CriticalSection::setBackendCritSecCreator(&SDL1_2CriticalSection::creator);

#if defined(WIN32) && defined(DEBUG)
	_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF|_CRTDBG_LEAK_CHECK_DF);
#endif

	DebugStatement(L"SDL1.2Main: App started.");

	int i;
	SDL1_2Application app;
	vector<wstring> args;

	for(i=1;i<argc;++i)
	{
		string tempstr(argv[i]);
		wstring tempstrW;

		UTF8File::charToWstring(tempstr, tempstrW);
		args.push_back(tempstrW);
	}

	CmdLineParams params(args);

	DebugStatement(L"SDL1.2Main: CmdLineParams initialised.");

	app.initialise(params);

	DebugStatement(L"SDL1.2Main: Application initialised.");

	app.eventLoop();

	DebugStatement(L"SDL1.2Main: Quitting.");

	return 0;
}
