//	SDL1.2KeyManager.h - SDL1.2-specific KeyManager.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef SDL1_2KEYMANAGER_H_
#define SDL1_2KEYMANAGER_H_

#include "KeyManager.h"

#include "SDL_events.h"

///	SDL1.2-specific KeyManager.
/*!
	This just handles the conversion between SDL_keysym and wstring key/event
	identifiers.
 */
class SDL1_2KeyManager : public KeyManager
{
  public:
	///	Constructor.
	SDL1_2KeyManager();
	///	Destructor.
	~SDL1_2KeyManager();

	///	Returns the action for the passed-in keyboard event.
	void getActions(SDL_keysym& keysym,
					std::vector<std::wstring>& actions) const;
	///	Returns the action for the passed-in joystick axis event.
	void getActions(SDL_JoyAxisEvent& event,
					std::vector<std::wstring>& actions) const;
	///	Returns the action for the passed-in joystick button event.
	void getActions(SDL_JoyButtonEvent& event,
					std::vector<std::wstring>& actions) const;
	///	Returns the action for the passed-in joystick hat event.
	void getActions(SDL_JoyHatEvent& event,
					std::vector<std::wstring>& actions) const;

	///	Helper method. Returns an int representing the modifier status.
	int getModVal(SDLMod& mod) const;
	///	Helper method. Returns a string representing an SDLKey value.
	std::wstring getKeyString(SDLKey key) const;
	///	Helper method. Returns the textual description of a joystick button event.
	std::wstring getJoyButtonText(SDL_JoyButtonEvent& event) const;
	///	Helper method. Returns the textual description of a joystick hat event.
	std::wstring getJoyHatText(SDL_JoyHatEvent& event) const;
};

#endif
