//	SDL1.2CriticalSection.h - A CriticalSection implementation based on SDL1.2.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef SDL1_2CriticalSection_H_
#define SDL1_2CriticalSection_H_

#include "CriticalSection.h"

typedef struct SDL_semaphore SDL_sem;

///	A CriticalSection implementation based on SDL1.2.
class SDL1_2CriticalSection : public BackendCritSec
{
  public:
	///	Constructor.
	SDL1_2CriticalSection();
	///	Destructor.
	~SDL1_2CriticalSection();

	///	(Waits until the critical section is free and) Locks the Critical Section.
	/*!
		\return True if it was successfully locked, false otherwise.
	 */
	bool lock();
	///	Unlocks the critical section.
	void unlock();

	///	Simple class used to construct an instance of a BackendCritSec subclass.
	class SDL1_2Creator : public BackendCritSec::Creator
	{
	  public:
		///	Constructor.
		SDL1_2Creator() {};
		///	Destructor.
		~SDL1_2Creator() {};

		///	Returns a new instance of a BackendCritSec subclass.
		BackendCritSecPtr createBackendCritSec() const
		{
			return BackendCritSecPtr(new SDL1_2CriticalSection());
		};
	};

	///	Our instance of SDL1_2Creator.
	static SDL1_2Creator creator;
  private:
	///	The SDL semaphore this critical section is based on.
	SDL_sem *semaphore;
};

#endif
