//	SDL1.2CriticalSection.cpp - A CriticalSection implementation based on
//								SDL1.2.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "SDL1.2CriticalSection.h"
#include "DebugHeaders.h"

#include "SDL_thread.h"

//------------------------------------------------------------------------------
SDL1_2CriticalSection::SDL1_2Creator SDL1_2CriticalSection::creator;

//------------------------------------------------------------------------------
SDL1_2CriticalSection::SDL1_2CriticalSection():
semaphore(0)
{
	semaphore = SDL_CreateSemaphore(1);
	if(!semaphore)
		DebugStatement(L"SDL1.2CriticalSection: Could not create semaphore!");
}

//------------------------------------------------------------------------------
SDL1_2CriticalSection::~SDL1_2CriticalSection()
{
	if(semaphore)
		SDL_DestroySemaphore(semaphore);
}

//------------------------------------------------------------------------------
bool SDL1_2CriticalSection::lock()
{
	if(semaphore)
		return SDL_SemWait(semaphore) == 0;
	else
		return false;
}

//------------------------------------------------------------------------------
void SDL1_2CriticalSection::unlock()
{
	SDL_SemPost(semaphore);
}
