//	ResourceManager.cpp - Class used to manage the various kinds of resource we
//						  might use.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "ResourceManager.h"
#include "sound/VorbisfileLoader.h"

using std::wstring;

//------------------------------------------------------------------------------
ResourceManager::ResourceManager()
{
	soundFileFactory.registerCreator(L"ogg", &VorbisfileLoader::creator);

	initialiseResources();
}

//------------------------------------------------------------------------------
ResourceManager::~ResourceManager()
{

}

//------------------------------------------------------------------------------
void ResourceManager::registerTextureAtlas(TextureAtlasPtr atlas)
{
	atlases.push_back(atlas);
}

//------------------------------------------------------------------------------
void ResourceManager::registerSingleImage(SingleImagePtr image)
{
	images.push_back(image);
}

//------------------------------------------------------------------------------
void ResourceManager::registerImageFolder(const FilePath& dir)
{
	folders.push_back(dir);
}

//------------------------------------------------------------------------------
void ResourceManager::registerShader(ShaderPtr shader)
{
	shaders.push_back(shader);
}

//------------------------------------------------------------------------------
void ResourceManager::registerFont(FontPtr font)
{
	fonts.push_back(font);
}

//------------------------------------------------------------------------------
void ResourceManager::registerSound(const FilePath& sound)
{
	sounds.push_back(sound);
}

//------------------------------------------------------------------------------
void ResourceManager::registerSoundFolder(const FilePath& dir)
{
	soundFolders.push_back(dir);
}

//------------------------------------------------------------------------------
void ResourceManager::registerSoundFileLoader(const wstring& extension,
											  SoundFileLoader::Creator *creator)
{
	soundFileFactory.registerCreator(extension, creator);
}

