//	GlobalData.h - Base class for storing global data.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef GLOBALDATA_H_
#define GLOBALDATA_H_

#include "c0xHeaders.h"

///	Base class for storing global data.
/*!
	The idea is that apps which need to e.g. share data between GameStates will
	create a subclass of this with all the members and methods that they need.

	GameStates can then access it via Application::getGlobalData().
 */
class GlobalData
{
  public:
	///	Constructor.
	GlobalData() {};
	///	Destructor.
	virtual ~GlobalData() {};
};

typedef shared_ptr<GlobalData> GlobalDataPtr;

#endif
