//	GameState.cpp - Base class for the various game states.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#include "GameState.h"
#include "Application.h"

using std::wstring;

//------------------------------------------------------------------------------
GameState::GameState(Application& app, SounderPtr& sound):
application(app)
{

}

//------------------------------------------------------------------------------
GameState::~GameState()
{

}

//------------------------------------------------------------------------------
void GameState::nextState(const wstring& newState, const wstring& extra)
{
	application.nextState(newState, extra);
}

//------------------------------------------------------------------------------
void GameState::quit()
{
	application.quit();
}

//------------------------------------------------------------------------------
void GameState::setMousePos(const TwoFloats& pos)
{
	application.setMousePos(pos);
}

//------------------------------------------------------------------------------
const ResourceManager& GameState::getResourceManager() const
{
	return application.getResourceManager();
}

//------------------------------------------------------------------------------
GlobalDataPtr GameState::getGlobalData()
{
	return application.getGlobalData();
}

//------------------------------------------------------------------------------
const TwoFloats& GameState::getDrawingAreaSize() const
{
	return application.getDrawingAreaSize();
}
