//	Font.h - Class holding some basic font information.
//  ----------------------------------------------------------------------------
//	This file is part of 'NiallsAVLib', base code for any kind of audiovisual
//	apps.
//	Copyright (C) 2012  Niall Moody
//	
//	This program is free software: you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation, either version 3 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.
//	----------------------------------------------------------------------------

#ifndef FONT_H_
#define FONT_H_

#include "FilePath.h"

///	Class holding some basic font information.
class Font
{
  public:
	///	Constructor.
	Font(const FilePath& fontPath, float fontSize, const std::wstring& fontId):
	filePath(fontPath),
	size(fontSize),
	id(fontId)
	{

	};
	///	Destructor.
	~Font() {};

	///	Returns the font's path.
	const FilePath& getPath() const {return filePath;};
	///	Returns the size of the font.
	float getSize() const {return size;};
	///	Returns the id which will be used to refer to the font.
	const std::wstring& getId() const {return id;};
  private:
	///	The font's path.
	FilePath filePath;
	///	The size of the font.
	float size;
	///	The id which will be used to refer to the font.
	std::wstring id;
};

#endif
